/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.block.basic;

import javax.annotation.Nonnull;
import mekanism.api.MekanismAPI;
import mekanism.api.text.EnumColor;
import mekanism.common.block.attribute.Attribute;
import mekanism.common.block.interfaces.IColoredBlock;
import mekanism.common.block.prefab.BlockTile;
import mekanism.common.content.blocktype.Machine;
import mekanism.common.tile.TileEntityFluidTank;
import mekanism.common.tile.base.WrenchResult;
import mekanism.common.util.FluidUtils;
import mekanism.common.util.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;

public class BlockFluidTank
extends BlockTile.BlockTileModel<TileEntityFluidTank, Machine<TileEntityFluidTank>>
implements IColoredBlock {
    public BlockFluidTank(Machine<TileEntityFluidTank> type) {
        super(type);
    }

    public int getLightEmission(BlockState state, BlockGetter world, BlockPos pos) {
        FluidStack fluid;
        int ambientLight = super.getLightEmission(state, world, pos);
        if (ambientLight == 15) {
            return ambientLight;
        }
        TileEntityFluidTank tile = WorldUtils.getTileEntity(TileEntityFluidTank.class, world, pos);
        if (tile != null && !(fluid = tile.fluidTank.getFluid()).isEmpty()) {
            int n;
            FluidAttributes fluidAttributes = fluid.getFluid().getAttributes();
            if (world instanceof BlockAndTintGetter) {
                BlockAndTintGetter tintGetter = (BlockAndTintGetter)world;
                n = fluidAttributes.getLuminosity(tintGetter, pos);
            } else {
                n = fluidAttributes.getLuminosity(fluid);
            }
            ambientLight = Math.max(ambientLight, n);
        }
        return ambientLight;
    }

    @Override
    @Nonnull
    @Deprecated
    public InteractionResult m_6227_(@Nonnull BlockState state, @Nonnull Level world, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult hit) {
        TileEntityFluidTank tile = WorldUtils.getTileEntity(TileEntityFluidTank.class, (BlockGetter)world, pos, true);
        if (tile == null) {
            return InteractionResult.PASS;
        }
        if (world.f_46443_) {
            return this.genericClientActivated(player, hand);
        }
        if (tile.tryWrench(state, player, hand, hit) != WrenchResult.PASS) {
            return InteractionResult.SUCCESS;
        }
        if (!player.m_6144_()) {
            if (!MekanismAPI.getSecurityUtils().canAccessOrDisplayError(player, (ICapabilityProvider)tile)) {
                return InteractionResult.FAIL;
            }
            ItemStack stack = player.m_21120_(hand);
            if (!stack.m_41619_() && FluidUtils.handleTankInteraction(player, hand, stack, tile.fluidTank)) {
                player.m_150109_().m_6596_();
                return InteractionResult.SUCCESS;
            }
        }
        return tile.openGui(player);
    }

    @Override
    public EnumColor getColor() {
        return Attribute.getBaseTier(this).getColor();
    }
}

